/****** Object:  Table [dbo].[Appearance]    Script Date: 04/19/2013 10:14:57 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Appearance]') AND type in (N'U'))
BEGIN
	/****** Object:  Table [dbo].[Appearance]    Script Date: 04/19/2013 10:14:57 ******/
	CREATE TABLE [dbo].[Appearance](
		[ModuleId] [int] NOT NULL,
		[PropertyName] [nvarchar](255) NOT NULL,
		[PropertyValue] [nvarchar](max) NOT NULL,
		[modifiedBy] [int] NULL,
		[modified] [datetime] NULL,
	 CONSTRAINT [PK_Appearance] PRIMARY KEY CLUSTERED 
	(
		[ModuleId] ASC,
		[PropertyName] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]
END
GO


/****** Object:  StoredProcedure [dbo].[VX_sp_GetAllAppearance]    Script Date: 04/19/2013 10:22:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetAllAppearance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_GetAllAppearance]
GO

/****** Object:  StoredProcedure [dbo].[VX_sp_GetAllAppearance]    Script Date: 04/19/2013 10:22:09 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[VX_sp_GetAllAppearance]
AS
BEGIN
 SET NOCOUNT ON;
 SELECT [ModuleId], [PropertyName], [PropertyValue], [ModifiedBy], [Modified] FROM [Appearance] 
END


GO
/****** Object:  StoredProcedure [dbo].[VX_sp_GetAppearance]    Script Date: 04/19/2013 10:22:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetAppearance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_GetAppearance]
GO

/****** Object:  StoredProcedure [dbo].[VX_sp_GetAppearance]    Script Date: 04/19/2013 10:22:09 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[VX_sp_GetAppearance]
   @ModuleId int
AS
BEGIN
 SET NOCOUNT ON;
 SELECT [ModuleId], [PropertyName], [PropertyValue], [ModifiedBy], [Modified] FROM [Appearance] WHERE [ModuleId] = @ModuleId
END


GO


/****** Object:  StoredProcedure [dbo].[VX_sp_UpdateAppearance]    Script Date: 04/19/2013 10:32:33 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_UpdateAppearance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_UpdateAppearance]
GO

/****** Object:  StoredProcedure [dbo].[VX_sp_UpdateAppearance]    Script Date: 04/19/2013 10:32:33 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [dbo].[VX_sp_UpdateAppearance]
   @ModuleId int,
   @PropertyName nvarchar(255),
   @PropertyValue nvarchar(max),
   @modifiedBy int,
   @modified datetime
AS
BEGIN
 SET NOCOUNT ON;
 
 	UPDATE [Appearance] SET
		[PropertyValue] = @PropertyValue, [ModifiedBy] = @ModifiedBy, [Modified] = @Modified
	WHERE
		[ModuleId] = @ModuleId AND [PropertyName] = @PropertyName

	IF @@ROWCOUNT = 0
	BEGIN
		 INSERT INTO [Appearance]
		 (ModuleId, PropertyName, PropertyValue, ModifiedBy, Modified)
		 SELECT @ModuleId, @PropertyName, @PropertyValue, @ModifiedBy, @Modified
	END
END

GO

/****** Object:  StoredProcedure [dbo].[VX_sp_DeleteAppearance]    Script Date: 04/19/2013 10:15:33 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_DeleteAppearance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_DeleteAppearance]
GO

/****** Object:  StoredProcedure [dbo].[VX_sp_DeleteAppearance]    Script Date: 04/19/2013 10:15:34 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [dbo].[VX_sp_DeleteAppearance]
   @ModuleId int
AS
BEGIN
 SET NOCOUNT ON;
 DELETE FROM [Appearance] where [ModuleId] = @ModuleId
END

GO

